/*
  Name: disk_image.c
  Copyright: 
  Author: 
  Date: 24/10/06 18:51
  Description: 
           
    
  Disk Copy 4.2 image handling derived from LisaFSh Tool by Ray Arachelian (www.sunder.net)
  corrected CRC checksum ()
  corrected some signed char issues
  
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>


#include <errno.h>

typedef signed char     int8;
typedef signed short    int16;
typedef signed long     int32;
typedef unsigned char   uint8;
typedef unsigned short  uint16;
typedef unsigned long   uint32;


typedef struct
{
    FILE *fhandle;
    char *filename;
    uint16 sectorsize;
    uint32 tagsize;
    uint32 numblocks;
    unsigned char *sectors;
    unsigned char *tags;
} FloppyType;

/*
 * 2 disk slots
 */

int init=0;
static int inserted=0;

FloppyType diska;
FloppyType diskb;

static int dc42_image_open(FloppyType *F);
static int dc42_image_close(FloppyType *F);

int get_sect_by_track(int track)
{
    if (track<=15) return 12;
    if (track<=31) return 11;
    if (track<=47) return 10;
    if (track<=63) return 9;
    return 8;
}

uint8 dummy[1024];

void unclamp(int drive) {
     if (init!=0) 
        dc42_image_close(&diska);
     init=0;
     inserted=0;
}

int check_inserted(int drive) {
    if (inserted) {
          inserted=0;
          return -1;         
    }
    return 0;   
}


int read_sector(int drive,int track,int sector,int side,unsigned char **data,unsigned char **tags)
{
    int bl,i;
    FloppyType *disk;
//    IDLE_INIT_FUNC("read_sector()");
    if (init==0) 
    {
       *data=dummy;
       *tags=dummy;
       return 7;
    }
    
    if (drive==0) disk=&diska;
    else
        disk=&diskb;
        
    
    bl=0;
    for (i=0;i<track;i++)
    {
        bl=bl+get_sect_by_track(i);
    }    
    bl+=sector;
//    IDLE_DEBUG("asked tr=%d sect=%d got %d",track,sector,bl);
    *data=&(disk->sectors[bl*disk->sectorsize]);
    *tags=&(disk->tags[bl*disk->tagsize]);
    return 0;
}

int read_sector_raw(int drive,int bl,unsigned char **data,unsigned char **tags)
{
    FloppyType *disk;
//    IDLE_INIT_FUNC("read_sector()");
    if (init==0) 
    {
       *data=dummy;
       *tags=dummy;
       return 7;
    }
    
    if (drive==0) disk=&diska;
    else
        disk=&diskb;
            
//    IDLE_DEBUG("asked tr=%d sect=%d got %d",track,sector,bl);
    *data=&(disk->sectors[bl*disk->sectorsize]);
    *tags=&(disk->tags[bl*disk->tagsize]);
    return 0;
}

int write_sector(int drive,int track,int sector,int side,unsigned char *data,unsigned char *tags)
{
    int bl,i;
    FloppyType *disk;
//    IDLE_INIT_FUNC("write_sector()");
    if (init==0) 
    {
       return 7;
    }
    
    if (drive==0) disk=&diska;
    else
        disk=&diskb;
        
    
    bl=0;
    for (i=0;i<track;i++)
    {
        bl=bl+get_sect_by_track(i);
    }    
    bl+=sector;
//    IDLE_TRACE("written tr=%d sect=%d got %d",track,sector,bl);
    memcpy(&(disk->sectors[bl*disk->sectorsize]),data,disk->sectorsize);
    memcpy(&(disk->tags[bl*disk->tagsize]),tags,disk->tagsize);
    return 0;
}

int write_sector_raw(int drive,int bl,unsigned char *data,unsigned char *tags)
{
    FloppyType *disk;
//    IDLE_INIT_FUNC("write_sector()");
    if (init==0) 
    {
       return 7;
    }
    
    if (drive==0) disk=&diska;
    else
        disk=&diskb;
        
    
//    IDLE_TRACE("written tr=%d sect=%d got %d",track,sector,bl);
    memcpy(&(disk->sectors[bl*disk->sectorsize]),data,disk->sectorsize);
    memcpy(&(disk->tags[bl*disk->tagsize]),tags,disk->tagsize);
    return 0;
}

int dc42_insert(char *filename,int drive)
{
    int ret;
    FILE *f;
//    IDLE_INIT_FUNC("dc42_insert");
    f=fopen(filename,"rb+");
    if (f==NULL)
    {
//                IDLE_TRACE("error opening %s",filename);
                return -1;
                }
    
    init=1;
    inserted=1;
    
    switch (drive) {
           case 0 : 
                diska.fhandle=f;
                diska.filename=(char*)malloc(strlen(filename)+1);
                strcpy(diska.filename,filename);
                ret=dc42_image_open(&diska);
                if (ret!=0) {init=0;inserted=0;}
                return ret;
           case 1: 
                diskb.fhandle=f;
                diskb.filename=(char*)malloc(strlen(filename)+1);
                strcpy(diskb.filename,filename);
                ret=dc42_image_open(&diskb);
                if (ret!=0) {init=0;inserted=0;}
                return ret;
           default:
                   return -1; 
                
           }
}

/*
 * the disk copy 4.2 image loader
 */
int dc42_image_open(FloppyType *F)
{

uint32 i,j;
char comment[65];
unsigned char dc42head[84];
uint32 datasize, tagsize, datachks, tagchks, mydatachks, mytagchks;

int ret;
//IDLE_INIT_FUNC("dc42_image_open()");
	errno=0;
	fseek(F->fhandle, 0,SEEK_SET);
	ret=fread(dc42head,84,1,F->fhandle);
	if ((ret!=1) || (errno)) {
//                  IDLE_ERROR("Error reading %s",F->filename);
                  return -1;
               }

	memcpy(comment,&dc42head[1],63);
	comment[63]=0;
	if (dc42head[0]<63) 
         comment[dc42head[0]]=0;

	datasize=(dc42head[64+0]<<24)|(dc42head[64+1]<<16)|(dc42head[64+2]<<8)|dc42head[64+3];
	tagsize =(dc42head[68+0]<<24)|(dc42head[68+1]<<16)|(dc42head[68+2]<<8)|dc42head[68+3];
	datachks=(dc42head[72+0]<<24)|(dc42head[72+1]<<16)|(dc42head[72+2]<<8)|dc42head[72+3];
	tagchks =(dc42head[76+0]<<24)|(dc42head[76+1]<<16)|(dc42head[76+2]<<8)|dc42head[76+3];

//	IDLE_TRACE("Header comment :\"%s\"",comment);
//	IDLE_DEBUG("Data Size      :%ld (0x%08x)",datasize,datasize);
//	IDLE_DEBUG("Tag total      :%ld (0x%08x)",tagsize,tagsize);
//	IDLE_DEBUG("Disk format    :%d  ",diskformat);

	F->sectorsize=512;
    F->numblocks=datasize/F->sectorsize;
	F->tagsize=tagsize/F->numblocks;

    F->numblocks=datasize/F->sectorsize; 
	F->tagsize=12; 

    if (F->numblocks!=800) {
//       IDLE_TRACE("ERROR : bad image");
       return -1;                       
    }
	F->sectors=(unsigned char *)malloc(F->numblocks * F->sectorsize) ; 
    if ( !F->sectors) { return -1;}
    F->tags=(unsigned char *)malloc(F->numblocks * F->tagsize);     
    if ( !F->tags ) { return -1;}


    memset(F->sectors,  0,( F->numblocks * F->sectorsize) );
    memset(F->tags,     0,( F->numblocks * F->tagsize   ) );

	fseek(F->fhandle,84,SEEK_SET);
	ret=0;
	for (j=0;j<F->numblocks;j++)
	{
	    ret+=fread(&F->sectors[j*F->sectorsize],F->sectorsize,sizeof(char),F->fhandle);
     	if (errno) {
                      fclose(F->fhandle);
                      return -1;
                      }
     }
//    IDLE_DEBUG("read %d",ret);
    
	mydatachks=0;
	for (i=0; i<F->numblocks; i++)
     for (j=0; j<F->sectorsize; j+=2) { mydatachks+=((F->sectors[i*(F->sectorsize)+j]<<8)|
                                                  (F->sectors[i*(F->sectorsize)+j+1]));
                                                  mydatachks=(mydatachks<<31)|(mydatachks>>1);
                                                  }
	ret=fread((char *) F->tags,F->tagsize,F->numblocks,F->fhandle);
	if (errno) {
                      fclose(F->fhandle);
                      return -1;
                      }
//    IDLE_DEBUG("read %d",ret);

	mytagchks=0;
	for ( i=0; i<F->numblocks; i++)
            for (j=0; j<F->tagsize; j+=2) {
                      mytagchks+=(F->tags[i*(F->tagsize)+j]<<8)|
                                 F->tags[i*(F->tagsize)+j+1]; 
                      mytagchks=(mytagchks<<31)|(mytagchks>>1);
            }

//	IDLE_TRACE("Header/Calc data chksum   :(0x%08x) ? (0x%08x):\n",datachks,mydatachks);
//	IDLE_TRACE("Header/Calc tag chksum    :(0x%08x) ? (0x%08x):\n",tagchks,mytagchks);

    return 0;
}

int dc42_image_close(FloppyType *F)
{

uint32 i,j;
unsigned char dc42head[84];
uint32 mydatachks, mytagchks;
int ret;
//IDLE_INIT_FUNC("dc42_image_close()");
	errno=0;
//IDLE_TRACE("called");

	fseek(F->fhandle,84,SEEK_SET);
    ret=0;
	for (j=0;j<F->numblocks;j++)
	{
	    ret+=fwrite(&F->sectors[j*F->sectorsize],F->sectorsize,sizeof(char),F->fhandle);
     	if (errno) {
                      fclose(F->fhandle);
                      return -1;
                      }
     }
//    IDLE_TRACE("write %d",ret);


    
	mydatachks=0;
	for (i=0; i<F->numblocks; i++)
     for (j=0; j<F->sectorsize; j+=2) { mydatachks+=((F->sectors[i*(F->sectorsize)+j]<<8)|
                                                  (F->sectors[i*(F->sectorsize)+j+1]));
                                                  mydatachks=(mydatachks<<31)|(mydatachks>>1);
                                                  }
	ret=fwrite((char *) F->tags,F->tagsize,F->numblocks,F->fhandle);
	if (errno) {
                      fclose(F->fhandle);
                      return -1;
                      }
//    IDLE_TRACE("write %d",ret);

	mytagchks=0;
	for ( i=0; i<F->numblocks; i++)
            for (j=0; j<F->tagsize; j+=2) {
                      mytagchks+=(F->tags[i*(F->tagsize)+j]<<8)|
                                 F->tags[i*(F->tagsize)+j+1]; 
                      mytagchks=(mytagchks<<31)|(mytagchks>>1);
            }


//    IDLE_TRACE("chks %x/%x",mydatachks,mytagchks);
    
	fseek(F->fhandle,72,SEEK_SET);
    
    dc42head[72]=(mydatachks&0xFF000000)>>24;
    dc42head[73]=(mydatachks&0xFF0000)>>16;
    dc42head[74]=(mydatachks&0xFF00)>>8;
    dc42head[75]=(mydatachks&0xFF);

    dc42head[76]=(mytagchks&0xFF000000)>>24;
    dc42head[77]=(mytagchks&0xFF0000)>>16;
    dc42head[78]=(mytagchks&0xFF00)>>8;
    dc42head[79]=(mytagchks&0xFF);

	ret=fwrite((char *) &dc42head[72],4,2,F->fhandle);

    fclose(F->fhandle);

    return 0;
}

