#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include "dosfs.h"
#include "disk_image.h"

/*
vme_dpb[0] = physical sector size in chars
vme_dpb[1] = cluster size in sectors
vme_dpb[2] = cluster size in chars
vme_dpb[3] = root directory length in sectors
vme_dpb[4] = FAT size in sectors (1 FAT)
vme_dpb[5] = 1st sector # of 2nd FAT
vme_dpb[6] = 1st sector # allocatable (where data begins)
vme_dpb[7] = total # of allocatable clusters
vme_dpb[8] = 0:12 bit FAT  1:16 bit FAT

BPB bpbx[] = {  {  512, 2, 1024,  5,  3,  4, 12,  390, 0 },
		{  512, 2, 1024,  5,  3,  4, 12,  390, 0 },
 		{  512, 2, 1024, 32, 12, 13, 57, 4000, 2 } ,
 		{  512, 2, 1024, 32, 12, 13, 57, 4000, 2 } } ;	
*/


int tr_dec[12]={0,2,4,6,8,10,1,3,5,7,9,11};

int nsect[80]={12,12,12,12,12,12,12,12,
	12,12,12,12,12,12,12,12,
	11,11,11,11,11,11,11,11,
	11,11,11,11,11,11,11,11,
	10,10,10,10,10,10,10,10,
	10,10,10,10,10,10,10,10,
	9,9,9,9,9,9,9,9,
	9,9,9,9,9,9,9,9,
	8,8,8,8,8,8,8,8,
	8,8,8,8,8,8,8,8};
	
int real_sect(int iblk,int *r_sect,int *r_trk) {
    int trk,sec,ns,ns2;
	sec = 0;
	for (trk = 0; trk < 80; sec += nsect[trk++]) if (iblk < sec) break;
	sec -= nsect[--trk];
	iblk -= sec;
	/* almost ready, but now the kicker... heavy duty skewing here */
	ns = (nsect[trk] + 1) >> 1;
	ns2 = ns << 1;
	/* skew by 2 */
	*r_sect = ((iblk << 1) + (iblk / ns)) % ns2;
	*r_trk=trk;
	
    return sec;
}

  char sector[512*4];

  char g_tags[12];

/*
	Read sector from image
	Returns 0 OK, nonzero for any error
*/
uint32_t DFS_ReadSector(uint8_t unit, uint8_t *buffer, uint32_t sector, uint32_t count)
{
  char tags[12];
  unsigned char *s, *t;
  int rs,rt;
  int ret;
  memset(tags,0,12);
  real_sect(sector,&rs,&rt);
  ret=read_sector(0,rt,rs,0,&s,&t);
  printf("reading logical %d sector %d track %d\n",sector,rs,rt);  
  memcpy(buffer,s,512);
  return 0;
}

/*
	Write sector to image
	Returns 0 OK, nonzero for any error
*/
uint32_t DFS_WriteSector(uint8_t unit, uint8_t *buffer, uint32_t sector, uint32_t count)
{
  unsigned char *s, *t;
  int rs,rt;
  int ret;
  char tags[12];
  real_sect(sector,&rs,&rt);
//  ret=read_sector(0,rt,rs,0,&s,&t);
//  memcpy(tags,t,12);
  memcpy(tags,g_tags,12);  
  write_sector(0,rt,rs,0,buffer,tags);  
  printf("writing logical %d sector %d track %d %c%c%c\n",sector,rs,rt,tags[0],tags[1],tags[2]);  
  return 0;
}

//void put_fat(char *fname,char *fat_fname,VOLINFO *vi) {
//	uint32_t cache;
//	FILEINFO fi;
//    char sector2[512];
//    FILE *f;
//    char *buf=malloc(1024*1024);
//    int fsize;
//    int i;
//    memset(sector,0,512);
//    memset(sector2,0,512);
//
//    f=fopen(fname,"rb");
//    fsize=fread(buf,1,1024*1024,f);
//    fclose(f);
//    printf("read %d bytes\n",fsize);
//
//	if (DFS_OpenFile(vi, fat_fname, DFS_WRITE, sector, &fi)) {
//		printf("error opening file %s\n",fat_fname);
//		exit(-1);
//	}
//	
//	for (i=0;i<(fsize/512);i++) {
//        printf("block %d\n",i);
//		memcpy(sector2,&buf[i*512] , SECTOR_SIZE);
//		DFS_WriteFile(&fi, sector, sector2, &cache, SECTOR_SIZE/2);
//		DFS_WriteFile(&fi, sector, sector2+256, &cache, SECTOR_SIZE/2);
//	}
//	if ((fsize % 512)>0) {
//		memcpy(sector2,&buf[i*512] , fsize%512);
//		DFS_WriteFile(&fi, sector, sector2, &cache, fsize%512);
//    }
//}
//
//char fat[512*3];
//char root[512*5];
//
//void upfat(int index,int val) {
//  if ((index % 2) == 0) {
//     fat[index+index/2]=val&0xFF;
//     fat[index+index/2+1]=(fat[index+index/2+1]&0xF0)|(val>>8);
//  }
//  else {
//     fat[index+index/2+1]=val&0xFF;
//     fat[index+index/2]=(fat[index+index/2]&0x0F)|((val>>4)&0xF0);
//  }
//}
//
//void put_fat2(char *fname,char *fatname,int nbcluster,int startcluster,int rootentry) {
//  char buf[1024*1024];
//  int size;
//  int blk;
//  int rs,rt;
//  FILE *f;
//  char tags[12];
//  memset(tags,0,12);
//  
//  f=fopen(fname,"rb");
//  size=fread(buf,1,1024*1024,f);
//  fclose(f);
//    
//  for (blk=0;blk<nbcluster*2;blk++)
//  {
//      real_sect(blk,&rs,&rt);          
//      write_sector(0,rt,rs,0,&buf[(blk)*512],tags);
//  }
//  
//}

int main(int argc, char *argv[])
{
  char tags[12];
  FILE *f;
  VOLINFO vi;
  DIRINFO di;
  DIRENT de;
  int rs,rt;
  int t;
  int tr;
        
  // insert image
  dc42_insert("gemdos.dc",0);
  
  // we first zap all content in file
  memset(sector,0,512);
  memset(tags,0,12);
  
  for (t=0;t<800;t++) {
      write_sector_raw(0,t,sector,tags);
  }

  sector[0] = 0xF7;
  sector[1] = 0xFF;
  sector[2] = 0xFF;

  // 1ST FAT
  real_sect(1,&rs,&rt);
  write_sector(0,rt,rs,0,sector,tags);  

  // 2ND FAT
  real_sect(4,&rs,&rt);
  write_sector(0,rt,rs,0,sector,tags);  

//  sector[0] = 'G';
//  sector[1] = 'E';
//  sector[2] = 'M';
//  sector[27]= 0x08;
    memset(sector,0xE5,512);

  // ROOT DIR
  real_sect(7,&rs,&rt);
  write_sector(0,rt,rs,0,sector,tags);  
 
  
  // then add boot
  f=fopen("SFBOOT.ABS","rb");
  memset(sector,0,512);
  memset(tags,0xAA,12);
  fread(sector,1,512,f);
  fclose(f);
  
  sector[11]=0x00;
  sector[12]=0x02;
  sector[13]=0x02;
  sector[14]=0x01;
  sector[15]=0x00;
  
  sector[16]=0x02; // 2 FAT
  sector[17]=0x50; // root size (5 sector ie 80 entries)
  sector[18]=0x00;
  
  sector[19]=0x20; // 800 sectors
  sector[20]=0x03;

  sector[21]=0xF9; // media

  sector[22]=0x03; // sector per FAT
  sector[23]=0x00;
  
  sector[24]=0x09; // sector per track
  sector[25]=0x00;
  

  write_sector_raw(0,0,sector,tags);  
  memset(tags,0,12);
/*
  f=fopen("GEMDOSFI.SYS","rb");
  fread(buf,1,65535,f);
  fclose(f);
  
  for (t=1;t<12;t++)
  for (s=0;s<12;s++)
  {
      write_sector(0,t,tr_dec[s],0,&buf[(s+12*(t-1))*512],tags);      
  }
*/
  
  // now start with FAT 
//	if (DFS_GetVolInfo(0, sector, 0, &vi)) {
//		printf("Error getting volume information\n");
//		return -1;
//	}
//	printf("Volume label '%-11.11s'\n", vi.label);
//	printf("%d sector/s per cluster, %d reserved sector/s, volume total %d sectors.\n", vi.secperclus, vi.reservedsecs, vi.numsecs);
//	printf("%d sectors per FAT, first FAT at sector #%d, root dir at #%d.\n",vi.secperfat,vi.fat1,vi.rootdir);
//	printf("(For FAT32, the root dir is a CLUSTER number, FAT12/16 it is a SECTOR number)\n");
//	printf("%d root dir entries, data area commences at sector #%d.\n",vi.rootentries,vi.dataarea);
//	printf("%d clusters (%d bytes) in data area, filesystem IDd as ", vi.numclusters, vi.numclusters * vi.secperclus * SECTOR_SIZE);
//	if (vi.filesystem == FAT12)
//		printf("FAT12.\n");
//	else if (vi.filesystem == FAT16)
//		printf("FAT16.\n");
//	else if (vi.filesystem == FAT32)
//		printf("FAT32.\n");
//	else
//		printf("[unknown]\n");
//
//	di.scratch = sector;
//	if (DFS_OpenDir(&vi, "", &di)) {
//		printf("Error opening root directory\n");
//		return -1;
//	}
//
//	while (!DFS_GetNext(&vi, &di, &de)) {
//		if (de.name[0])
//			printf("file: '%-11.11s'\n", de.name);
//	}
//
//
////  put_fat("GEMDOSFI.SYS","GEMDOSFI.SYS",&vi);
////  put_fat("COMMAND.PRG","COMMAND.PRG",&vi);
//    put_fat("SFBOOT.ABS","SFBOOT.ABS",&vi);
//	if (DFS_OpenDir(&vi, "", &di)) {
//		printf("Error opening root directory\n");
//		return -1;
//	}
//
//	while (!DFS_GetNext(&vi, &di, &de)) {
//		if (de.name[0])
//			printf("file: '%-11.11s'\n", de.name);
//	}

  // unclamp (close and save image)
  
  // this one must be first...
  write_fs("GEMDOSFI.SYS","GEMDOSFI.SYS");
    
  write_fs("COMMAND.PRG","COMMAND.PRG");  

  write_fs("GEMVDI.PRG","GEMVDI.PRG");  

  write_fs("GEM.PRG","GEM.PRG");  
  write_fs("GEM.RSC","GEM.RSC");  

  
  write_fs("ASSIGN.SYS","ASSIGN.SYS");  
  write_fs("LISA25.SYS","LISA25.SYS");  
  write_fs("META.SYS","META.SYS");  
  write_fs("IBMHSS10.FNT","IBMHSS10.FNT");  
  write_fs("IBMHSS14.FNT","IBMHSS14.FNT");  
  write_fs("IBMHSS18.FNT","IBMHSS18.FNT");  
  write_fs("IBMHSS36.FNT","IBMHSS36.FNT");  

  write_fs("DESKTOP.APP","DESKTOP.APP");  
  write_fs("DESKTOP.INF","DESKTOP.INF");    
  write_fs("DESKHI.ICN","DESKHI.ICN");  

  write_fs("DATE.PRG","DATE.PRG");  


//  write_fs("GEMDOSHI.SYS","GEMDOSHI.SYS");  
  write_fs("HBOOT.ABS","HBOOT.ABS");  
  write_fs("SFBOOT.ABS","SFBOOT.ABS");  

//  write_fs("MINCE.PRG","MINCE.PRG");  
//  write_fs("MCONFIG.PRG","MCONFIG.PRG");  
  write_fs("FORMAT.PRG","FORMAT.PRG");  
  
  write_fs("HELLO.APP","HELLO.APP");  

  write_fs("SID.PRG","SID.PRG");  
  
  // recopie FAT1 vers FAT2
  for (tr=0;tr<3;tr++) {
      char *s,*t;
      real_sect(tr+1,&rs,&rt);
      read_sector(0,rt,rs,0,&s,&t);
      memcpy(tags,t,12);
      memcpy(sector,s,512);

      real_sect(tr+1+3,&rs,&rt);      
      write_sector(0,rt,rs,0,sector,tags);  
      printf("writing FAT logical %d to %d sector %d track %d\n",tr+1,tr+1+2,rs,rt);  
  }

  // then add boot
  f=fopen("SFBOOT.ABS","rb");
  memset(sector,0,512);
  memset(tags,0xAA,12);
  fseek(f,28,SEEK_SET);
  fread(sector,1,512-28,f);
  fclose(f);
  write_sector_raw(0,0,sector,tags);  
  memset(tags,0,12);
  
  unclamp(0);

  return 0;
}
